// config: norepeat

#include "GetObjects.js"

function DoCopy()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.showUI( 'BasePointPrompt' );
	moi.ui.showUI( 'BaseOptions' );
	moi.ui.endUIUpdate();

	var basept;
	
	var pointpicker = moi.ui.createPointPicker();
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			basept = pointpicker.pt;
			break;
		}
			
		if ( pointpicker.event == 'BoundingBoxCenter' )
		{
			basept = objects.getHighAccuracyBoundingBox().center;
			moi.ui.addPickedPoint( basept );
			break;
		}		
	}
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePointPrompt' );
	moi.ui.hideUI( 'BaseOptions' );
	moi.ui.showUI( 'TargetPointPrompt' );
	moi.ui.endUIUpdate();

	pointpicker.restrictToPlaneThroughPt( basept, false );
	pointpicker.stickToSurfacesMode = 'none';
	
	moi.command.setCommandSpecificUndo( true );
	var created_objects_stack = new Array();

	while ( 1 )
	{
		var factory = moi.command.createFactory( 'copy' );
	
		factory.setInput( 0, objects );
		factory.setInput( 1, basept );

		pointpicker.clearBindings();
		pointpicker.bindResultPt( factory.getInput(2) );
		pointpicker.resetOnMouseLeave = true;

		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return;
				
			if ( pointpicker.event == 'done' || pointpicker.event == 'finished' )
				break;
				
			if ( pointpicker.event == 'undo' && created_objects_stack.length > 0 )
				moi.geometryDatabase.removeObjects( created_objects_stack.pop() );
		}
		
		if ( pointpicker.event == 'done' )
			break;
			
		if ( pointpicker.event == 'finished' )
		{
			created_objects_stack.push( factory.getCreatedObjects() );
		
			factory.commit();
			moi.ui.removeLastPickedPoint();
		}
	}
}

DoCopy();
